DROP PROCEDURE [hips].[UnitTypeCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the UnitType Code Table
-- =============================================
CREATE PROCEDURE [hips].[UnitTypeCodeGet] 
(
	@CodeSystemCode VARCHAR(20),
	@UnitTypeId INT = NULL
)
AS
BEGIN

	SELECT  ut.UnitTypeId, ut.Code, ut.Description
	FROM    hips.UnitTypeCode utc
			JOIN hips.UnitType ut ON utc.UnitTypeId = ut.UnitTypeId
			JOIN hips.CodeSystem cs ON utc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND (ut.UnitTypeId = @UnitTypeId OR @UnitTypeId IS NULL)
	ORDER BY ut.Description

END
GO

